<?php
/* BongopayBD WHMCS Plugin
 *
 * Developer: Biplob Hossen
 * Website: https://bongopaybd.com/
 */

if (!defined("WHMCS")) {
    die("This file cannot be accessed directly");
}

function bongopaybd_MetaData()
{
    return array(
        'DisplayName' => 'BongopayBD',
        'APIVersion' => '1.0',
        'DisableLocalCredtCardInput' => true,
        'TokenisedStorage' => false,
    );
}

function bongopaybd_link($params)
{
    $host_config = $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
    $host_config = pathinfo($host_config, PATHINFO_FILENAME);

    if (isset($_POST['pay'])) {
        $response = bongopaybd_payment_url($params);
        if ($response->status) {
            return '<form action="' . $response->payment_url . '" method="GET">
            <input class="btn btn-primary" type="submit" value="' . $params['langpaynow'] . '" />
            </form>';
        }

        return $response->message;
    }

    if ($host_config == "viewinvoice") {
        return '<form action="" method="POST">
        <input class="btn btn-primary" name="pay" type="submit" value="' . $params['langpaynow'] . '" />
        </form>';
    } else {
        $response = bongopaybd_payment_url($params);
        if ($response->status) {
            return '<form action="' . $response->payment_url . '" method="GET">
            <input class="btn btn-primary" type="submit" value="' . $params['langpaynow'] . '" />
            </form>';
        }

        return $response->message;
    }
}

function bongopaybd_config()
{
    return array(
        'FriendlyName' => array(
            'Type' => 'System',
            'Value' => 'BongopayBD',
        ),
        'apiKey' => array(
            'FriendlyName' => 'API Key',
            'Type' => 'text',
            'Size' => '150',
            'Default' => '',
            'Description' => 'Enter Your BongopayBD API Key',
        ),
        'currency_rate' => array(
            'FriendlyName' => 'Currency Rate',
            'Type' => 'text',
            'Size' => '150',
            'Default' => '85',
            'Description' => 'Enter conversion rate if invoice currency is USD',
        )
    );
}

function bongopaybd_payment_url($params)
{
    $cus_name = $params['clientdetails']['firstname'] . " " . $params['clientdetails']['lastname'];
    $cus_email = $params['clientdetails']['email'];

    $apikey = $params['apiKey'];
    $currency_rate = $params['currency_rate'];
    $invoiceId = $params['invoiceid'];

    $amount = ($params['currency'] == "USD") ? $params['amount'] * $currency_rate : $params['amount'];

    $protocol = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on') ? "https://" : "http://";
    $systemUrl = $protocol . $_SERVER['HTTP_HOST'];

    $webhook_url = $systemUrl . '/modules/gateways/callback/bongopaybd.php?api=' . $apikey . '&invoice=' . $invoiceId;
    $success_url = $systemUrl . '/viewinvoice.php?id=' . $invoiceId;
    $cancel_url = $systemUrl . '/viewinvoice.php?id=' . $invoiceId;

    $data = [
        "cus_name" => $cus_name,
        "cus_email" => $cus_email,
        "amount" => $amount,
        "webhook_url" => $webhook_url,
        "success_url" => $success_url,
        "cancel_url" => $cancel_url,
    ];

    $curl = curl_init();
    curl_setopt_array($curl, [
        CURLOPT_URL => "https://secure.bongopaybd.com/api/payment/create",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => json_encode($data),
        CURLOPT_HTTPHEADER => [
            'Content-Type: application/json',
            'API-KEY: ' . $apikey
        ],
        CURLOPT_TIMEOUT => 30
    ]);

    $response = curl_exec($curl);
    $err = curl_error($curl);
    curl_close($curl);

    if ($err) {
        return (object)['status' => false, 'message' => "cURL Error: $err"];
    }

    $res = json_decode($response, true);

    if (isset($res['status']) && $res['status'] && isset($res['payment_url'])) {
        return (object)['status' => true, 'payment_url' => $res['payment_url']];
    } else {
        return (object)['status' => false, 'message' => $res['message'] ?? 'Payment URL could not be generated'];
    }
}
