<?php
/* BongopayBD WHMCS Gateway
 *
 * Developer: BIPLOB Hossen
 * Website: https://bongopaybd.com
 */

require_once __DIR__ . '/../../../init.php';
require_once __DIR__ . '/../../../includes/gatewayfunctions.php';
require_once __DIR__ . '/../../../includes/invoicefunctions.php';

use WHMCS\Config\Setting;

// Get request parameters
$invoiceId = $_REQUEST['invoice'] ?? null;
$transactionId = $_REQUEST['transactionId'] ?? null;
$paymentAmount = $_REQUEST['paymentAmount'] ?? 0;
$paymentFee = $_REQUEST['paymentFee'] ?? 0;
$gatewayModuleName = "bongopaybd";

// Validate essential fields
if (!$invoiceId || !$transactionId) {
    die("Invalid Request. Invoice or Transaction ID missing.");
}

// API Credentials (these should come from module settings)
$apiKey = $_GET['api'] ?? '';  // or load from WHMCS Gateway config
$verifyUrl = "https://secure.bongopaybd.com/api/payment/verify";

// Prepare POST data
$postData = json_encode(['transaction_id' => $transactionId]);

// Setup cURL
$curl = curl_init();
curl_setopt_array($curl, [
    CURLOPT_URL => $verifyUrl,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => $postData,
    CURLOPT_HTTPHEADER => [
        'Content-Type: application/json',
        'API-KEY: ' . $apiKey
    ],
    CURLOPT_TIMEOUT => 30
]);

$response = curl_exec($curl);
$err = curl_error($curl);
curl_close($curl);

if ($err) {
    die("cURL Error: " . $err);
}

// Decode response
$data = json_decode($response, true);

if (!$data || !isset($data['status'])) {
    die("Invalid response from BongopayBD API.");
}

// Check payment status
if ($data['status'] === 'COMPLETED') {
    // Add payment to WHMCS
    addInvoicePayment(
        $invoiceId,
        $transactionId,
        $paymentAmount,
        $paymentFee,
        $gatewayModuleName
    );

    // Redirect user to invoice page
    $systemUrl = Setting::getValue('SystemURL');
    echo "<script>location.href='{$systemUrl}/viewinvoice.php?id={$invoiceId}';</script>";
    exit;
} else {
    echo "Payment verification failed or payment not completed.";
}
?>
